setadr equ $60000               * Zieladresse des Programms
                                * Anpassung mu an eigenes Ram erfolgen

*******************************************************************************
*                      68000/68010 Grundprogramm varequ                       *
*                         (C) 1991 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                           Variablen und EQUs                                *
*******************************************************************************

ram equ $10000                  * Relativer Abstand Variable-Basis

rsreset                         * Counter vorsichtshalber auf Null setzen

vekdest:   rs.b 0               * INIT-Start fr Transport

intlv2:    rs.b 6               * Auto-Interrupt LV2 (nmi)
intlv5:    rs.b 6               * Auto-Interrupt LV5 (int)
intlv7:    rs.b 6               * Auto-Interrupt LV7 (nmi+int)
trap0:     rs.b 6               * Trap0-Vektor

userci:    rs.b 6               * Vektor USER-CI
                                * d0 = 0 Zugriff ci2
                                * d0 = 1 Erster Zugriff auf ci2 nach ciinit2
                                * d0 = 2 Zugriff von ci
usercsts:  rs.b 6               * Vektor USER-CSTS
                                * d0 = 2 Zugriff von csts
userco:    rs.b 6               * Vektor USER-CO

iostat:    rs.b 1               * Flag fr Ausgabe bei CO2 (Umschalter)
                                * 1 = Ausgabe auf CRT mit ERRFLAG-Abfrage
                                * 2 = Ausgabe auf CRT
                                * 3 = Auf Drucker
                                * 4 = Auf Drucker ohne LF
                                * 5 = USER-CO
                                * 6 = Ausgabe ber serielle Schnitstelle
iostatb:   rs.b 1               * CI und CI2 Umschalter
                                * 5 = Umschaltung auf USERCI
iodir:     rs.b 1               * Fr CTRL-A Umschaltung bei co2

akteprom:  rs.b 1               * Aktuelles Eprom fr schnelle Wahl

flip:      rs.b 1               * Fr Seitenumschaltung bei AUTOFLIP
flipcnt:   rs.b 1               * Flip ist fr Zwei-Seiten-Umschaltung
flip1:     rs.b 1               * Flip1 fr Vier-Seitenbetrieb
flip1cnt:  rs.b 1               * Null, dann Flip aus

passflag:  rs.w 1               * Aktueller PASS beim Assembler
                                * (1=erster Durchgang / 2=zweiter Durchgang)
errflag:   rs.w 1               * Fehlerflag (0 = Kein Fehler beim Assembler)

stxtxt:    rs.l 1               * Zeiger auf Textanfang
akttxt:    rs.l 1               * Zeiger auf Startzeile des Bildschirms
etxtxt:    rs.l 1               * Zeiger auf Textende
errzeile:  rs.l 1               * Zeiger auf erste fehlerhafte Zeile beim
                                * Assemblerdurchlauf

turx:      rs.w 1               * X-Position Turtle * 16
tury:      rs.w 1               * Y-Position Turtle * 32
turphi:    rs.w 1               * Winkel der Turtle
tur1x:     rs.w 1               * Merker der alten X-Position
tur1y:     rs.w 1               * Merker der alten Y-Position
tur1phi:   rs.w 1               * Merker des alten Winkels

pcstand:   rs.l 1               * Programmzhlerstand beim Assembler
anfstand:  rs.l 1               * PC am Anfang einer Zeile
auspoi:    rs.l 1               * Pointer Ausgabe
einpoi:    rs.l 1               * Eingabepointer
auszahl:   rs.w 1               * Anzahl ausgegebener Bytes beim Assembler

stackmerk: rs.l 1               * Stack-Merker bei Trace

nametab:   rs.b 8               * Name fr Symboltabelle
ausbuf:    rs.b 132             * Ausgabebuffer (berall nur lokal verwenden !)
einbuf:    rs.b 132             * Eingabebuffer (auch nur lokal verwenden !)

regsave:   rs.b 4*16            * d0-d7/a0-a7 bei Einzelschritt
tracflag:  rs.b 1               * Modi bei Einzelschrittbearbeitung
                                * Bit 0 = Regdump an/aus
                                * Bit 1 = Protokol an/aus
                                * Bit 2 = TRAP/JSR Direktausfhrung
                                * Bit 3 = (Nur 68020)
                                * Bit 4 = Trace aus/an
                                * Bit 6,7 = (Nur 68020)
gdpsave:   rs.b 15              * gdp1-gdp15
srsave:    rs.w 1               * Statusregister
pcsave:    rs.l 1               * PC nchster Befehl
uspsave:   rs.l 1               * User-Stack-Pointer
sspsave:   rs.l 1               * Supervisor-Stack-Pointer

tracmerk:  rs.b 6               * Merker fr Werte bei Einzelschritt
trac1aus:  rs.b 1               * Auswahlmerker fr Wiederholen
tracausw:  rs.b 1               * Auswahl bei trace
                                * 0 = Nichts
                                * 1 = Bis
                                * 2 = N-Mal
                                * 3 = Weiter bis ADRESSE mit MASKE WERT enthlt
                                * 4 = Weiter bis zum nchsten RTS/RTE/RTR

modber:    rs.b 8               * Hilfsablage fr Direktausfhrung eines Befehls

trac1mer:  rs.l 1               * Wert-Zwischenspeicher fr Wiederholen
           rs.l 1               * FREI !!!

offset:    rs.l 1               * Fr verschobene Programme
pcorg:     rs.l 1               * Default PC-Start, wenn kein ORG da
uhradr:    rs.w 1               * Wenn vorhanden, Smart-Watch Adresse/8 Kbyte
attcode:   rs.w 1               * Attribute fr Befehlssatz
wordbyte:  rs.w 1               * Lngenmerker fr Assembler

errcnt:    rs.w 1               * Anzahl der Fehler
errart:    rs.w 1               * Fehlerart
errpoi:    rs.l 1               * Zeiger auf Fehlerquelle

debugst:   rs.l 1               * Start Debugger Info
debugak:   rs.l 1               * Nchste freie Zelle

oldx:      rs.w 1               * Alte X-Position bei FIGUR-Befehl
oldy:      rs.w 1               * Alte Y-Position
oldadr:    rs.l 1               * Adresse der Figur
oldsize:   rs.w 1               * Gre der Figur (Dx und Dy)

uhrausw:   rs.b 1               * Uhrauswahl
                                * Wenn keine Smart-Watch vorhanden und keine
                                * Uhrenbaugruppe gewhlt :
                                * 0 = Es wird die Uhrenbaugruppe angesprochen,
                                * obwohl sie nicht vorhanden ist=>Kompatibilitt
                                * 1 = E050-16 Uhrenbaugruppe vorhanden
                                * 2 = DS1216 (Smart-Watch) im Ram
                                * 3 = RTC

viewpage:  rs.b 1               * Aktuelle Leseseite 0..3
wrtpage:   rs.b 1               * Aktuelle Schreibseite 0..3

synstate:  rs.b 1               * Fr Sync-Aufruf

menflag:   rs.b 1               * Menumschaltung
                                * Bit 0 = frei
                                * Bit 1 = frei
                                * Bit 2 = Grundprogramm als Aufruf (nein,ja)
                                * Bit 6 = Hardcopy immer erlaubt (nein,ja)
                                * Bit 7 = Grundprogramm an (ja/nein)

groesse:   rs.b 1               * Gre bei CO-Ausgabe
           rs.b 1               * FREI !!!

first:     rs.b 1               * Fr Turtle-Grafik (1 = first)
turdo:     rs.b 1               * Turtle down (0 = up)

zeilen:    rs.b 1               * Zeilenzhler
debug:     rs.b 1               * Debug-Flag (1 = dann gltige Info)

insl:      rs.b 1               * Einfgemode / Blockmerker beim Editor
                                * Bit 0 = Einfgemode (0 = aus)
                                * Bit 1 = Blockanfang markiert
                                * Bit 2 = Blockende markiert
                                * Bit 3 = Scroll-Art (Seitenweise/Zeilenweise)
                                * Bit 4 = Auf Zeilenanfang / Textanfang

curon:     rs.b 1               * 1 = CRT-Cursor aktiv
curx:      rs.b 1               * Cursor-Position 0..79
cury:      rs.b 1               * 0..23
escmerker: rs.b 1               * Escape Flag

lrand:     rs.b 1               * Linker Rand im Editor

cotempo:   rs.b 1               * Scrollgeschwindigkeit bei neuer GDP
                                * 0 = Software-Scroll
                                * 1-5 = Hardware-Scroll

optflag:   rs.b 1               * Zeichensatzmerker
                                * 0 = amerikanisch
                                * 1 = deutsch (default)
                                * 2 = User definiert

linecnt:   rs.b 24              * Zeichen-Zhler pro Zeile
lineptr:   rs.b 24              * Pointer auf reale Zeile
screen:    rs.b 80*24           * Bildschirmbuffer

           rs.b 41              * Freibereich fr ersten Stack

stack:     rs.b 2               * Stack beim Reset bevor Rambereich ermittelt

trap2:     rs.b 6               * Vektoren fr USER-Traps
trap3:     rs.b 6
trap6:     rs.b 6
trap7:     rs.b 6
trap8:     rs.b 6
trap9:     rs.b 6
trap10:    rs.b 6
trap11:    rs.b 6
trap12:    rs.b 6
trap13:    rs.b 6
trap14:    rs.b 6
trap15:    rs.b 6
trap1:     rs.b 6               * Grundprogrammtrap ins Ram gefhrt

linea:     rs.b 6               * linea,linef eingefhrt, dadurch
linef:     rs.b 6               * Softareschnittstelle fr FPU/PMMU
                                * realisierbar

intlv1:    rs.b 6               * Interrupt-Ebenen 1, 3, 4, 6
intlv3:    rs.b 6
intlv4:    rs.b 6
intlv6:    rs.b 6

                                * ACHTUNG !!!
                                * Ab hier Speicheraufbau verndert
steprate:  rs.b 1               * Steprate bei Floppy ( 0-7 )
flosr:     rs.b 1               * Statusregister FLO beim letzten Zugriff


drvat:     rs.b 1               * Merker fr altes Laufwerk
drvtab:    rs.b 16              * Spurtabelle Laufwerke

ioflag:    rs.b 1               * Flag fr verschiedene Baugruppen im IO-Bereich
                                * Bit 0 : 0 = GDP / 1 = GDPHS
                                * Bit 1 : 0 = Normale Key / 1 = Key3
                                * Bit 2 : 0 = Keine Ser / 1 = Ser vorhanden
                                * Bit 3 : 0 = Keine Ser2 / 1 = Ser2 vorhanden

rnd1var:   rs.w 1               * RANDOM Indizes
rnd2var:   rs.w 1               * Zufllig belegt fr
rnd3var:   rs.w 1               * Knudt-Algorithmus

pagecnt:   rs.w 1               * Seitenzhler beim Assembler
hdtab:     rs.b 10              * Tabelle fr HARDDISK

fgcolor:   rs.b 1               * Vordergrundfarbe fr erweiterte GDP
xormode:   rs.b 1               * 0..15 XOR-Flag fr neu GDP (Nur Bit 0 genutzt)
ci2flag:   rs.b 1               * 1 = Erster Zugriff bei USER-CI

coscroll:  rs.b 1               * Scrollwert der GDP Baugruppe bei Scroll
                                * mit der CO-Routine
                                * In Zweier-Schritten von Null bis 254

                                * Druckmodi fr Druckersteuerung
dflag0:    rs.b 1               * Bit 0+1  Zeichensatzwahl
                                * (0=Amerikanisch/1=Deutsch/2=NDR)
                                * Bit 2    Zeichensatz des Druckers
                                * Bit 3    Papiererkennung
                                * Bit 4    Kursivdruck
                                * Bit 5    Proportionaldruck
                                * Bit 6    Doppeldruck
                                * Bit 7    Fettdruck
dflag1:    rs.b 1               * Bit 0+1  Druckart (Normal/Breit/Schmal)
                                * Bit 2    Schriftart
                                * Bit 3    Druckrichtung
                                * Bit 4    Druckgeschwindigkeit
                                * Bit 5-7  Anzahl Kopien

dflag2:    rs.b 1               * Seitenlnge
dflag3:    rs.b 1               * Linker Rand

drbeftab:  rs.b 3*22            * Tabelle der Druckerbefehle
                                * 22 Befehle mit maximal 3 Bytes Lnge

serflag:   rs.b 1               * Bit 0 = ci/csts auf serielle Karte gelenkt
                                * Bit 1 = lo/lsts auf serielle Karte gelenkt
                                * Bit 2 = Floppy auf serielle Karte gelenkt
                                *       (Nur Sektor lesen und Sektor schreiben)

* grafflag:  rs.b 1               * Grafik Flag fr Grafik-Paket
                                * 0 = GDP
                                * 1 = COL256 (512*256 Punkte 16 Farben)

gdpscroll: rs.b 1               * Scrollwert GDP-Karte
gdpxor:    rs.b 1               * Verknpfungsmode GDP (0/1)
gdpvpage:  rs.b 1               * Leseseite GDP (0-3)
gdpwpage:  rs.b 1               * Schreibseite GDP (0-3)
gdpcolor:  rs.b 1               * Schreibfarbe GDP (0/1)
gdpcol:    rs.b 1               * 0= S/W-GDP, 1= Farb-GDP

* colxor:    rs.b 1               * Verknpfungsmode bei der COL-Karte (0/1)
* colvpage:  rs.b 1               * Leseseite COL (0-3)
* colwpage:  rs.b 1               * Schreibseite COL (0-3)
* colcolor:  rs.b 1               * Schreibfarbe COL (0-15)
* colcol1:   rs.b 1               * Schreibfarbe COL Teil 1
* colcol2:   rs.b 1               * Schreibfarbe COL Teil 2

keydil:    rs.b 1               * Kopie der DIL-Schalter auf der KEY-Karte

colscroll: rs.w 1               * Scrollwert der COL-Karte
bootflag:  rs.l 1               * Kennung, ob Boot erfolgte
colpadr:   rs.l 1               * Adresse fr die Punkt-Routine
colram:    rs.l 1               * Ram-Adresse der COL-Karte (default $ec000*cpu)

poweron:   rs.l 1               * Poweron-Erkennung bei Reset

symnext:   rs.w 1               * Zeiger auf nchsten Eintrag bei Symtab
                                * 16 Bit vorzeichenlos

macrotab:  rs.l 1               * Enthlt die Adresse der Tabelle der Macros
macroanf:  rs.l 1               * Hilfspeicher und Macrozieladresse

anfzeile:  rs.l 1               * Anfangsadresse der gerade bersetzten Zeile
                                * im Assembler
rscount:   rs.l 1               * RS-Zhler fr den Assembler

           rs.l 3*5             * Nur bei 68020
           rs.l 1               * Nur bei 68020

mausadr0:  rs.b 6               * Eingabegert initialisieren
mausadr1:  rs.b 6               * Eingabegert abfragen

drsave:    rs.b 20              * Eigene Druckerbefehle beim Druckmen

edittabs:  rs.b 80              * Feld fr Tabs bei Edit
                                * Bit 7 gesetzt = Tab vorhanden

editmacro: rs.b 41*10           * Platz fr 10 Macros

aktser:    rs.b 1               * Aktueller SER Kanal
                                * 0=keine SER, 1=SER
                                * 2=SER2 Kanal A, 3=SER2 Kanal B

scsi2ide:  rs.b 1               * SCSI Kommandos auf IDE umleiten
                                * 0=keine Umleitung,
                                * 1=Umleitung auf IDE aktiv
                                * 2=Umleitung auf SD-Card aktiv

idemgeo:   rs.b 32              * IDE Master Geometrie
idesgeo:   rs.b 32              * IDE Slave Geometrie

idebuff:   rs.b 512             * IDE Buffer

srdcap:    rs.w 1               * SRAMDISK Kapazitt

flo2srd:   rs.b 1               * Floppy4 nach SRAMDISK umleiten

bootdel:   rs.b 1               * Wartezeit bis Laufwerk zum booten bereit

nvrbuff:   rs.b 32              * Kopie des NVRAMs

cmdbuff:   rs.b 6               * SD-Card Kommado-Puffer

sd1geo:    rs.b 24              * SD-Card 1 Geometrie
sd2geo:    rs.b 24              * SD-Card 2 Geometrie

fontname:  rs.b 4               * Name der User-Schriftart

bgcolor:   rs.b 1               * Hintergrundfarbe fr GDP

transmod:  rs.b 1               * Transparent-Modus der GDP-FPGA

        
* dummy:     rs.b 1               * Wird bentigt um auf Word-Grenze zu kommen

                                * Folgende Variable ist frei nach hinten
                                * verschiebbar. Deshalb ist hier Platz fr neue
                                * Variablen.
symtab:    rs 0                 * Symboltabellenbereich bis 64 Kbyte

****************************** Ende der Variablen ******************************

cpu       equ 2                 * 68000/68010 Grundprogramm

page      equ $ffffff60*cpu     * Seitenport GDP
page1     equ $ffffff61*cpu     * Extraport fr Scroll

gdp       equ $ffffff70*cpu     * GDP-Prozessor Basisadresse
colport   equ $ffffffa0*cpu     * 1. Farbport GDP (Vordergrund)
colport1  equ $ffffffa1*cpu     * 2. Farbport GDP (Hintergrund)

keyd      equ $ffffff68*cpu     * Daten Tastatur + Strobe
keys      equ $ffffff69*cpu     * Schalter + Rcksetzen
                                * Bit 0 = Reserve
                                * Bit 1 = 1 => Autoboot
                                * Bit 2 = 1 => Uhrenbaugruppe vorhanden
                                * Bit 3 = 1 => GDPHS
                                * Bit 4 = 1 => SCSI-Disk
                                * Bit 5 = 1 => IDE-Disk
                                * Bit 6 = 1 => GDP-FPGA

bankboot  equ $ffffffc8*cpu     * Bank-Boot-Karte

promd     equ $ffffff80*cpu     * Adressen fr Eprom-Programmierer
proma1    equ $ffffff81*cpu     * Promer und Promer2
proma2    equ $ffffff82*cpu
proma3    equ $ffffff83*cpu
proma4    equ $ffffff84*cpu
proma5    equ $ffffff85*cpu
proma6    equ $ffffff86*cpu
proma7    equ $ffffff87*cpu

cmdcas    equ $ffffffca*cpu     * Cassettenrecorder Port
datcas    equ $ffffffcb*cpu

centdaten equ $ffffff48*cpu     * Datenport Drucker
centin    equ $ffffff49*cpu     * Busy-Status Bit 0
centstb   equ $ffffff49*cpu     * Strobe Ausgang Bit 0

flo0      equ $ffffffc0*cpu     * Floppy-Controller Kommandoregister
flo1      equ $ffffffc1*cpu     * Trackregister
flo2      equ $ffffffc2*cpu     * Sektorregister
flo3      equ $ffffffc3*cpu     * Datenregister
flo4      equ $ffffffc4*cpu     * Status und Steuerung

hddata    equ $ffffff24*cpu     * Harddisk Daten-Register
hdstat    equ $ffffff25*cpu     * Harddisk Status-Register
hdsel     equ $ffffff26*cpu     * Harddisk Selcect-Port
hdcode    equ $ffffff26*cpu     * Harddisk Port fr Adresse-Codierung

srddata   equ $ffffff2c*cpu     * SRAMDISK Daten Register
srdsecl   equ $ffffff2d*cpu     * SRAMDISK Sektor Register Low Byte
srdsech   equ $ffffff2e*cpu     * SRAMDISK Sektor Register High Byte

idedor    equ $ffffff16*cpu     * GIDE Digitales Ausgabe-Register
idedat    equ $ffffff18*cpu     * GIDE Daten-Register
ideerr    equ $ffffff19*cpu     * GIDE Error-Register
idescnt   equ $ffffff1a*cpu     * GIDE Sektor-Zaehler
idesnum   equ $ffffff1b*cpu     * GIDE Sektor-Nummer
ideclo    equ $ffffff1c*cpu     * GIDE Zylinder Low-Byte
idechi    equ $ffffff1d*cpu     * GIDE Zylinder High-Byte
idesdh    equ $ffffff1e*cpu     * GIDE Sektor Groesse, Laufwerk, Kopf
idecmd    equ $ffffff1f*cpu     * GIDE Status(lesen) und Komandos(schreiben)

spictrl   equ $ffffff00*cpu     * SPI-Control / SPI per IOE
spidata   equ $ffffff01*cpu     * SPI Daten

ser0      equ $fffffff0*cpu     * Serielles Interface (SER)
ser1      equ $fffffff1*cpu
ser2      equ $fffffff2*cpu
ser3      equ $fffffff3*cpu

ser20     equ $ffffff90*cpu     * Mode Reg Channel A (SER2)
ser21     equ $ffffff91*cpu     * Status / Clock Select-Reg Channel A
ser22     equ $ffffff92*cpu     * Masked Interrupt Status / Cmd Reg Channel A
ser23     equ $ffffff93*cpu     * Rx Holding / Tx Holding Reg Channel A
ser24     equ $ffffff94*cpu     * Input Port Change / Auxilary Control Reg
ser25     equ $ffffff95*cpu     * Interrupt Status / Interrupt Mask Reg
ser26     equ $ffffff96*cpu     * Counter/Timer Upper Byte Reg
ser27     equ $ffffff97*cpu     * Counter/Timer Lower Byte Reg
ser28     equ $ffffff98*cpu     * Mode Reg Channel B
ser29     equ $ffffff99*cpu     * Status / Clock Select Reg Channel B
ser2a     equ $ffffff9a*cpu     * Reserved / Command Reg Channel B
ser2b     equ $ffffff9b*cpu     * Rx Holding / Tx Holding Reg Channel B
ser2c     equ $ffffff9c*cpu     * Interrupt Vector Reg
ser2d     equ $ffffff9d*cpu     * Input Port / Output Port Configuration Reg
ser2e     equ $ffffff9e*cpu     * Set Output Port Bits
ser2f     equ $ffffff9f*cpu     * Clear Output Port Bits

adc0816   equ $ffffffe0*cpu     * Analog-Digital-Wandler 16 Kanle
adc1001   equ $fffffffc*cpu     * Analog-Digital-Wandler 1 Kanal
da0802    equ $fffffff8*cpu     * Digital-Analog-Wandler 2 Kanle

ad12      equ $ffffffd0*cpu     * 12 Bit Analog-Digital-Wandler
da12      equ $ffffffd4*cpu     * 12 Bit Digital-Analog-Wandler

uhr       equ $fffffffe*cpu     * Uhrenkarte

rtcreg    equ $fffffffa*cpu     * RTC Adressregister
rtcdat    equ $fffffffb*cpu     * RTC Daten

spra0     equ $ffffffd8*cpu     * Sprachausgabe
spra1     equ $ffffffd9*cpu
spra2     equ $ffffffda*cpu
spra3     equ $ffffffdb*cpu
spra4     equ $ffffffdc*cpu

snd0      equ $ffffff50*cpu     * Sound-Baugruppe
snd1      equ $ffffff51*cpu

mtast     equ $ffffff8b*cpu     * Hardcopy-Maus-Baugruppe
mauf      equ $ffffff8c*cpu     * Mausports
mab       equ $ffffff8d*cpu
mrechts   equ $ffffff8e*cpu
mlinks    equ $ffffff8f*cpu

kreuzlx   equ $ffffff89*cpu     * Ports des Fadenkreuzes
kreuzhx   equ $ffffff88*cpu
kreuzly   equ $ffffff8b*cpu
kreuzhy   equ $ffffff8a*cpu

hardcad8  equ $ffffff89*cpu     * 8-Bit Port

hardclat  equ $ffffff8d*cpu     * Zhler bernehmen
hardcclr  equ $ffffff8e*cpu     * Zhler lschen

* colcrt     equ $ffffffac*cpu    * Register-Auswahl
* colcrtd    equ $ffffffad*cpu    * Register-Ansprech-Adresse
* colpage    equ $ffffffae*cpu    * Seiteneinstellung und Ein-Ausblenden der Karte

cluta      equ $ffffffa4*cpu    * FPGA-CLUT Adresse
cluth      equ $ffffffa5*cpu    * FPGA-CLUT Daten high
clutl      equ $ffffffa6*cpu    * FPGA-CLUT Daten low


******************************** Ende EQU-Anweisungen **************************
                                                                                                                  